﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VIRP_WEB.SoaServices;
using AntiXssEnc = Microsoft.Security.Application;

namespace VIRP_WEB.Controls.Survey
{
    public partial class SurveyQuestionScale : System.Web.UI.UserControl
    {
        public List<SURVEY_RESULTS> Questions { get; set; }
        public List<SURVEY_RESULTS> Results { get; set; }

        protected void Page_Load(object sender, EventArgs e)
        {
        }

        public void BuildQuestion()
        {
            STD_QUESTION stdQuestion = Questions.First().STD_QUESTION;

            var tr = new TableRow();
            var tc = new TableCell();
            var tbl = new Table();
            tbl.CssClass = "virp-survey-scale-table";

            tr = new TableRow();

            //Empty cell
            tr.Cells.Add(new TableCell());

            foreach (SURVEY_RESULTS question in Questions)
            {
                if (question.STD_QUESTION_CHOICE != null)
                {
                    var lblChoice = new Label();
                    lblChoice.Text = AntiXssEnc.Encoder.HtmlEncode(question.STD_QUESTION_CHOICE.CHOICE_TEXT);
                    tc = new TableCell();
                    tc.CssClass = "virp-survey-scale-choice-th";
                    tc.Controls.Add(lblChoice);
                    tr.Cells.Add(tc);
                }
            }
            tbl.Rows.Add(tr);

            tr = new TableRow();

            var lblQuestion = new Label();
            lblQuestion.ID = "lbl" + stdQuestion.ID.ToString();
            string validatedQuestionText = AntiXssEnc.Encoder.HtmlEncode(stdQuestion.QUESTION_TEXT);
            validatedQuestionText = validatedQuestionText.Replace("&#10;", "<BR>");
            if (!string.IsNullOrEmpty(AntiXssEnc.Encoder.HtmlEncode(stdQuestion.QUESTION_NUMBER)))
                lblQuestion.Text = AntiXssEnc.Encoder.HtmlEncode(stdQuestion.QUESTION_NUMBER) + ") " + validatedQuestionText;
            else
                lblQuestion.Text = validatedQuestionText;
            tc = new TableCell();
            tc.CssClass = "virp-survey-scale-question";
            tc.Controls.Add(lblQuestion);
            tr.Cells.Add(tc);

            foreach (SURVEY_RESULTS question in Questions)
            {
                tc = new TableCell();

                if (question.STD_QUESTION_CHOICE != null)
                {
                    var rb = new RadioButton();
                    rb.Text = "";
                    rb.Attributes.Add("value", question.SURVEY_RESULT_ID.ToString());
                    rb.Checked = question.SELECTED_FLAG;
                    rb.GroupName = question.STD_QUESTION_ID.ToString();
                    tc = new TableCell();
                    tc.CssClass = "virp-survey-scale-choice-td";
                    tc.Controls.Add(rb);
                    tr.Cells.Add(tc);
                }
            }
            tbl.Rows.Add(tr);

            phQuestions.Controls.Add(tbl);
        }

        public string BuildNoteTemplate()
        {
            StringBuilder sbNote = new StringBuilder();

            STD_QUESTION stdQuestion = Questions.First().STD_QUESTION;

            /*Display all possible choices*/
            //sbNote.Append("(");
            //int count = 0;
            //foreach (SURVEY_RESULTS question in Questions)
            //{
            //    if (question.STD_QUESTION_CHOICE != null)
            //    {
            //        string strChoice = question.STD_QUESTION_CHOICE.CHOICE_TEXT;
            //        if (count != 0)
            //        {
            //            sbNote.Append(", ");
            //        }
            //        sbNote.Append(strChoice);

            //        var lblChoice = new Label();
            //        lblChoice.Text = question.STD_QUESTION_CHOICE.CHOICE_TEXT;

            //        count++;
            //    }
            //}
            //sbNote.AppendLine(")");

            string strQuestion = stdQuestion.QUESTION_TEXT;
            if (!string.IsNullOrEmpty(stdQuestion.QUESTION_NUMBER))
            {
                strQuestion = stdQuestion.QUESTION_NUMBER + ") " + strQuestion;
                sbNote.AppendLine(strQuestion);
            }
            else
            {
                sbNote.AppendLine(strQuestion);
            }

            foreach (SURVEY_RESULTS question in Questions)
            {
                if (question.STD_QUESTION_CHOICE != null)
                {
                    if (question.SELECTED_FLAG)
                    {
                        sbNote.Append("- " + question.STD_QUESTION_CHOICE.CHOICE_TEXT);
                    }
                }
            }
            sbNote.AppendLine();

            return sbNote.ToString();
        }

        public void SaveQuestion()
        {
            Table tbl = phQuestions.Controls[0] as Table;
            if (tbl != null && tbl.Rows != null)
            {
                foreach (TableRow tr in tbl.Rows)
                {
                    foreach (TableCell tc in tr.Cells)
                    {
                        foreach (var rb in tc.Controls.OfType<RadioButton>())
                        {
                            int resultId = 0;
                            if (int.TryParse(rb.Attributes["value"].ToString(), out resultId))
                            {
                                foreach (SURVEY_RESULTS result in Results)
                                {
                                    if (result.SURVEY_RESULT_ID == resultId)
                                        result.SELECTED_FLAG = rb.Checked;
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}